// temperatur.cpp : einfach die Temperatur des Clewarefhlers anzeigen/ jschleede
//
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include "USBaccess.h"

int main(int argc, char* argv[]) {
	CUSBaccess CWusb ;

	// printf("Start USB Access Example!\n") ;

	int USBcount = CWusb.OpenCleware() ;
	// printf("OpenCleware found %d devices\n", USBcount) ;

	for (int devID=0 ; devID < USBcount ; devID++) {
		int devType = CWusb.GetUSBType(devID) ;
		//printf("Device %d: Type=%d, Version=%d, SerNum=%d\n", devID,devType, CWusb.GetVersion(devID),CWusb.GetSerialNumber(devID)) ;
		//printf("argc=%d\n", argc) ;
		
		if (devType == CUSBaccess::TEMPERATURE_DEVICE || devType == CUSBaccess::TEMPERATURE2_DEVICE) {
			//CWusb.ResetDevice(devID) ;
    		//usleep(300*1000) ;		// etwas warten
			double temperatur ;
			int	   zeit ;
			if (!CWusb.GetTemperature(devID, &temperatur, &zeit)) {
			printf("GetTemperature(%d) failed\n", devID) ;
			return 1 ;
			}
			//printf("Measured %lf Celsius, time = %d\n", temperatur, zeit) ;
			printf("%lf\n", temperatur) ;
			
		}
	}
	CWusb.CloseCleware() ;

	return 0;
}

